/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.mixin;

import com.itayfeder.nock_enough_arrows.compat.curios.CuriosCompat;
import com.itayfeder.nock_enough_arrows.init.EnchantmentInit;
import com.itayfeder.nock_enough_arrows.quiver.QuiverItem;
import com.itayfeder.nock_enough_arrows.quiver.QuiverItemStackHandler;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ArrowItem.class}, remap=false)
public class ArrowItemMixin {
    @Inject(locals=LocalCapture.CAPTURE_FAILSOFT, method={"isInfinite"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInfiniteInjection(ItemStack stack, ItemStack bow, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (this.matchProjectileInQuiver(bow, player, stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    private boolean matchProjectileInQuiver(ItemStack p_36349_, Player player, ItemStack stack) {
        boolean found;
        Inventory inventory = player.m_150109_();
        if (!(p_36349_.m_41720_() instanceof ProjectileWeaponItem)) {
            return false;
        }
        Predicate predicate = ((ProjectileWeaponItem)p_36349_.m_41720_()).m_6437_();
        if (ModList.get().isLoaded("curios") && (found = CuriosCompat.findQuiverInCuriosSlot(p_36349_, player, stack))) {
            return true;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack ist;
            ItemStack itemstack1 = inventory.m_8020_(i);
            if (!(itemstack1.m_41720_() instanceof QuiverItem) || inventory.f_35978_.f_19853_.f_46443_) continue;
            CompoundTag capTag = ((QuiverItem)itemstack1.m_41720_()).getShareTag(itemstack1).m_128469_("cap");
            QuiverItem cfr_ignored_0 = (QuiverItem)itemstack1.m_41720_();
            QuiverItemStackHandler quiverItemStackHandler = QuiverItem.getQuiverItemStackHandler(itemstack1);
            QuiverItem cfr_ignored_1 = (QuiverItem)itemstack1.m_41720_();
            int selectedSlot = QuiverItem.getSelected(itemstack1);
            if (!predicate.test(quiverItemStackHandler.getStackInSlot(selectedSlot)) || !(ist = quiverItemStackHandler.getStackInSlot(selectedSlot)).equals(stack, false)) continue;
            int recoveryLevel = itemstack1.getEnchantmentLevel((Enchantment)EnchantmentInit.RECOVERY.get());
            Random rnd = new Random();
            if (rnd.nextInt(100) >= recoveryLevel * 5) continue;
            return true;
        }
        return false;
    }
}

